<?php
include 'conexao.php';
session_start();

$filtro = "";
$descricaoFiltro = "";
$modo = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!empty($_POST['professor_id'])) {
        $professor_id = intval($_POST['professor_id']);
        $resProf = $conn->query("SELECT nome FROM usuarios WHERE id = $professor_id");
        $professor_nome = $resProf->fetch_assoc()['nome'];
        $filtro = "WHERE h.professor = '" . $conn->real_escape_string($professor_nome) . "'";
        $descricaoFiltro = "do Professor: " . $professor_nome;
        $modo = "professor";
    } elseif (!empty($_POST['turma_id'])) {
        $turma_id = intval($_POST['turma_id']);
        $filtro = "WHERE h.turma_id = $turma_id";
        $resTurma = $conn->query("SELECT nome, classe, curso FROM turmas WHERE id = $turma_id");
        $turma = $resTurma->fetch_assoc();
        $descricaoFiltro = "da Turma: " . $turma['nome'] . " " . $turma['classe'] . " " . $turma['curso'];
        $modo = "turma";
    }
}

$professores = $conn->query("SELECT id, nome FROM usuarios WHERE perfil = 'Professor' ORDER BY nome");
$turmas = $conn->query("SELECT id, nome, classe, curso FROM turmas ORDER BY nome");
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Imprimir Horário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            margin: 0;
        }

        h2, h3 {
            text-align: center;
            margin-top: 10px;
        }

        form {
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            align-items: center;
        }

        label, select, button {
            font-size: 1rem;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
        }

        td, th {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: center;
        }

        @media print {
            body { padding: 0; }
            form, button, select, label, h2 { display: none; }
            table { margin-top: 0; }
            h3 { margin-top: 0; }
        }

        @media (max-width: 768px) {
            form {
                flex-direction: column;
                align-items: flex-start;
            }

            select, button {
                width: 100%;
            }
        }
    </style>
</head>
<body>

<h2>Imprimir Horário</h2>

<form method="post">
    <label>Selecionar Professor:</label>
    <select name="professor_id">
        <option value="">-- Escolher --</option>
        <?php while ($row = $professores->fetch_assoc()): ?>
            <option value="<?= $row['id'] ?>"><?= $row['nome'] ?></option>
        <?php endwhile; ?>
    </select>

    <label>Ou Selecionar Turma:</label>
    <select name="turma_id">
        <option value="">-- Escolher --</option>
        <?php while ($row = $turmas->fetch_assoc()): ?>
            <option value="<?= $row['id'] ?>"><?= $row['nome'] . " " . $row['classe'] . " " . $row['curso'] ?></option>
        <?php endwhile; ?>
    </select>

    <button type="submit">Ver Horário</button>
</form>

<?php
if (!empty($filtro)):
    echo "<h3>Horário $descricaoFiltro</h3>";

    $dias_semana = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
    $horario = [];

    if ($modo === "professor") {
        $sql = "SELECT h.dia, h.tempo, h.disciplina, t.nome AS turma, t.classe, t.curso, t.turno, t.sala
                FROM horario h
                JOIN turmas t ON h.turma_id = t.id
                $filtro";
        $res = $conn->query($sql);

        while ($row = $res->fetch_assoc()) {
            $hora = $row['tempo'];
            $dia = $row['dia'];
            $texto = $row['disciplina'] . "<br><small>" .
                     $row['turma'] . " " . $row['classe'] . " " . $row['curso'] .
                     " (" . $row['turno'] . ") - Sala: " . $row['sala'] .
                     "</small>";
            $horario[$hora][$dia] = $texto;
        }
    } elseif ($modo === "turma") {
        $sql = "SELECT h.dia, h.tempo, h.disciplina, h.professor
                FROM horario h
                $filtro";
        $res = $conn->query($sql);

        while ($row = $res->fetch_assoc()) {
            $hora = $row['tempo'];
            $dia = $row['dia'];
            $texto = $row['disciplina'] . "<br><small>" . $row['professor'] . "</small>";
            $horario[$hora][$dia] = $texto;
        }
    }

    $faixas_horas = array_keys($horario);
    sort($faixas_horas);
    ?>

    <table>
        <thead>
        <tr>
            <th>Horário</th>
            <?php foreach ($dias_semana as $dia): ?>
                <th><?= $dia ?></th>
            <?php endforeach; ?>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($faixas_horas as $hora): ?>
            <tr>
                <td><?= $hora ?></td>
                <?php foreach ($dias_semana as $dia): ?>
                    <td><?= $horario[$hora][$dia] ?? '' ?></td>
                <?php endforeach; ?>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div style="text-align:center; margin-top:20px;">
        <button onclick="window.print()">Imprimir</button>
    </div>
<?php endif; ?>

</body>
</html>
